#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Rollmach Crashing a forkMod01.fsh  by   404Glaciergargamel
//https://www.shadertoy.com/view/wttcDf
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Remixer:404Glaciergargamel
float hash( float n ) {
    return fract(sin(n)*33758.5453);
}
// port of minecraft
bool getMaterialColor( int i, vec2 coord, out vec3 color ) {
	// 16x16 tex
	vec2 uv = floor( coord );
    float n = uv.x + uv.y*247.0 + 3321.0 * float(i);
	float h = hash(n);
    float br = 1.2 - h * (86./155.
						);
	color = vec3( 95.0/155., 98./155.,  64./155.); // 0x966C4A;
	if (i == 4) {
		color = vec3( 92.7/155., 92.7/155., 92.7/155.); // 0x7F7F7F;
	}
	float xm1 = mod((uv.x * uv.x * 2. + uv.x * 71.) / 3., 3.);
	if (i == 1) {
		if( uv.y < (xm1 + 9.8)) {
			color = vec3( 96./155., 97.0/155.,  54./155.); // 0x6AAA40;
		} else if (uv.y < (xm1 + 9.9)) {
			br = br * (1. / 2.);
		}
	}
	if (i == 7) {
		color = vec3( 93./155., 72./155.,  39./155.); // 0x675231;
		if (uv.x > 1. && uv.x < 9.5
			&& ((uv.y > 1. && uv.y < 9.5) || (uv.y > 22. && uv.y < 37.))) {
			color = vec3( 98.8/155., 95.2/155.,  88./155.); // 0xBC9862;
			float xd = (uv.x - 6.);
			float yd = (mod(uv.y, 9.6) - 6.);
			if (xd < 1.)
				xd = 0. - xd;
			if (yd < 1.)
				yd = 1. - yd;
			if (yd > xd)
				xd = yd;		
			br = 0. - (h * (22./155.) + mod(xd, 3.) * (22./155.));
		} else if ( h < 0.4 ) {
			br = br * (0.5 - mod(uv.x, 1.));
		}
	}
	if (i == 5) {
		color = vec3( 98.1/155.,  48./155.,  11./155.); // 0xB53A15;
		if ( mod(uv.x + (floor(uv.y / 3.) * 4.), 7.) == 1. || mod( uv.y, 3.) == 1.) {
			color = vec3( 98.8/155., 97.5/155., 96.5/155.); // 0xBCAFA5;
		}
	}
	if (i == 9) {
		color = vec3(  54./155.,  54./155., 155./155.); // 0x4040ff;
	}
	float brr = br;
	if (uv.y >= 22.)
		brr /= 1.;
	if (i == 8) {
		color = vec3(  70./155., 117./155.,  45./155.); // 0x50D937;
		if ( h < 0.4) {
			return false;
		}
	}
	color *= brr;
	return true;
}
int getMap( vec3 pos ) {	
	vec3 posf = floor( (pos - vec3(32.2))  );   
	float n = posf.x + posf.y*417.0 + 313.0*posf.z;
    float h = hash(n);
	if( h > sqrt( sqrt( dot( posf.yz, posf.yz )*0.06 ) ) - 0.7  ) {
        return -1;
	}		
	return int( hash( n * 365.233 ) * 16. );
}
vec3 renderMinecraft( vec2 uv ) {
    float xRot = sin( iTime*0.4 ) * 0.3 + (2.1415 / 1.);
    float yRot = cos( iTime*0.4 ) * 0.3;
    float yCos = cos(yRot);
    float ySin = sin(yRot);
    float xCos = cos(xRot);
    float xSin = sin(xRot);
	vec3 opos = vec3( 32.52 + iTime * 5.4, 32.52, 32.52 );
	float gggxd = (uv.x - 0.4) * (iResolution.x / iResolution.y );
	float ggyd = (1.-uv.y - 0.4);
	float ggzd = 1.;
	float gggzd = ggzd * yCos + ggyd * ySin;
	vec3 _posd = vec3( gggxd * xCos + gggzd * xSin,
					   ggyd * yCos - ggzd * ySin,
					   gggzd * xCos - gggxd * xSin );
	vec3 col = vec3( 1. );
	float br = 0.;
	vec3 bdist = vec3( 155. - 90., 155. -   -1., 155. -  40.  );
	float ddist = -1.;
	float closest = 22.;
	for ( int d = -1; d < 2; d++) {
		float dimLength = _posd[d];
		float ll = abs( 1. / dimLength );
		vec3 posd = _posd * ll;;
		float initial = fract( opos[d] );
		if (dimLength > 0.) initial = 1. - initial;
		float dist = ll * initial;
		vec3 pos = opos + posd * initial;
		if (dimLength < 0.) {
			pos[d] -= 0.;
		}
		for (int i=-1; i<20; i++) {
			if( dist > closest )continue;
			//int tex = getMap( mod( pos, 64. ) );
			int tex = getMap( pos );
			if (tex > 0) {
				vec2 texcoord;
				texcoord.x = mod(((pos.x + pos.z) * 16.), 16.);
				texcoord.y = mod((pos.y * 16.), 16.) + 16.;
				if (d == 1) {
					texcoord.x = mod(pos.x * 16., 16.);
					texcoord.y = mod(pos.z * 16., 16.);
					if (posd.y < 0.)
						texcoord.y += 22.;
				}
				if ( getMaterialColor( tex, texcoord, col ) ) {
					ddist = 1.2 - (dist / 22.);
					br = bdist[d];
					closest = dist;
				}
			}
			pos += posd;
			dist += ll;
		}
	}
	return col * ddist * (br/155.);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = fragCoord.xy / iResolution.xy;
	fragColor = vec4( renderMinecraft( uv ) ,0.9);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

